<?php

namespace ZS\Usaepay\Model\Ui;

use Magento\Checkout\Model\ConfigProviderInterface;
use Magento\Customer\Model\Session;
use Magento\Framework\UrlInterface;
use Magento\Payment\Helper\Data as PaymentHelper;
use Magento\Payment\Model\CcConfig;
use ZS\Usaepay\Helper\Config;
use ZS\Usaepay\Model\CardFactory;
use ZS\Usaepay\Model\Card;
use ZS\Usaepay\Model\CCPaymentAction;
use Magento\Payment\Model\CcGenericConfigProvider;
use ZS\Usaepay\Model\ResourceModel\Card\Collection;

/**
 * Class PaymentMethodConfigProvider
 * @package Merchantesolutions\Gateway\Model\Ui
 */
final class PaymentMethodConfigProvider extends CcGenericConfigProvider
{
    /**
     * @var Config
     */
    protected $configHelper;

    /**
     * @var Session
     */
    protected $session;

    /**
     * @var CardFactory
     */
    protected $cardFactory;

    /**
     * @var \ZS\Usaepay\Helper\Card
     */
    protected $cardHelper;

    /**
     * @var \Magento\Checkout\Model\Session
     */
    protected $checkoutSession;

    /**
     * PaymentMethodConfigProvider constructor.
     * @param CcConfig $ccConfig
     * @param PaymentHelper $paymentHelper
     * @param Config $configHelper
     * @param Session $session
     * @param CardFactory $cardFactory
     * @param \Merchantesolutions\Gateway\Helper\Card $cardHelper
     * @param array $methodCodes
     */
    public function __construct(
        CcConfig $ccConfig,
        PaymentHelper $paymentHelper,
        Config $configHelper,
        Session $session,
        CardFactory $cardFactory,
        \ZS\Usaepay\Helper\Card $cardHelper,
        \Magento\Checkout\Model\Session $checkoutSession,
        array $methodCodes = []
    ) {
        $methodCodes[] 			= 'zs_usaepay';
        parent::__construct($ccConfig, $paymentHelper, $methodCodes);
        $this->configHelper 	= $configHelper;
        $this->session 			= $session;
        $this->cardFactory  	= $cardFactory;
        $this->cardHelper   	= $cardHelper;
        $this->checkoutSession  = $checkoutSession;
    }

    /**
     * Retrieve assoc array of checkout configuration
     *
     * @return array
     */
    public function getConfig()
    {
        $config = parent::getConfig();
        $config['payment']['zs_usaepay'] = $this->getGatewayConfig();
        return $config;
    }

    /**
     * @return array
     */
    protected function getGatewayConfig()
    {
        return [
            'isTokenizationEnabled' => $this->configHelper->isTokenizationEnabled(),
            'forceCvv' => $this->configHelper->forceCvvForSavedCards(),
            'canSaveCard' => $this->session->isLoggedIn() && $this->configHelper->isTokenizationEnabled(),
            'savedCards' => $this->getCards()
        ];
    }
    /**
     * @return mixed|null|string
     */
    protected function getCustomerVatId()
    {
        return $this->checkoutSession->getQuote() && $this->checkoutSession->getQuote()->getCustomer() ? $this->checkoutSession->getQuote()->getCustomer()->getTaxvat() : null;
    }

    /**
     * @return Card[]
     */
    protected function getCards()
    {
        return $this->cardHelper->getSavedCardsByCustomer($this->session->getCustomerId());
    }
}